/*
 * Decompiled with CFR 0.152.
 */
package com.ms.studio.models;

import com.ms.studio.utils.PatchUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.util.Assert;
import run.halo.app.core.extension.content.Snapshot;

public class ContentWrapper {
    private String snapshotName;
    private String raw;
    private String content;
    private String rawType;

    public static ContentWrapper patchSnapshot(Snapshot patchSnapshot, Snapshot baseSnapshot) {
        Assert.notNull((Object)baseSnapshot, (String)"The baseSnapshot must not be null.");
        String baseSnapshotName = baseSnapshot.getMetadata().getName();
        if (StringUtils.equals((CharSequence)patchSnapshot.getMetadata().getName(), (CharSequence)baseSnapshotName)) {
            return ContentWrapper.builder().snapshotName(patchSnapshot.getMetadata().getName()).raw(patchSnapshot.getSpec().getRawPatch()).content(patchSnapshot.getSpec().getContentPatch()).rawType(patchSnapshot.getSpec().getRawType()).build();
        }
        String patchedContent = PatchUtils.applyPatch(baseSnapshot.getSpec().getContentPatch(), patchSnapshot.getSpec().getContentPatch());
        String patchedRaw = PatchUtils.applyPatch(baseSnapshot.getSpec().getRawPatch(), patchSnapshot.getSpec().getRawPatch());
        return ContentWrapper.builder().snapshotName(patchSnapshot.getMetadata().getName()).raw(patchedRaw).content(patchedContent).rawType(patchSnapshot.getSpec().getRawType()).build();
    }

    ContentWrapper(String snapshotName, String raw, String content, String rawType) {
        this.snapshotName = snapshotName;
        this.raw = raw;
        this.content = content;
        this.rawType = rawType;
    }

    public static ContentWrapperBuilder builder() {
        return new ContentWrapperBuilder();
    }

    public String getSnapshotName() {
        return this.snapshotName;
    }

    public String getRaw() {
        return this.raw;
    }

    public String getContent() {
        return this.content;
    }

    public String getRawType() {
        return this.rawType;
    }

    public void setSnapshotName(String snapshotName) {
        this.snapshotName = snapshotName;
    }

    public void setRaw(String raw) {
        this.raw = raw;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public void setRawType(String rawType) {
        this.rawType = rawType;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ContentWrapper)) {
            return false;
        }
        ContentWrapper other = (ContentWrapper)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$snapshotName = this.getSnapshotName();
        String other$snapshotName = other.getSnapshotName();
        if (this$snapshotName == null ? other$snapshotName != null : !this$snapshotName.equals(other$snapshotName)) {
            return false;
        }
        String this$raw = this.getRaw();
        String other$raw = other.getRaw();
        if (this$raw == null ? other$raw != null : !this$raw.equals(other$raw)) {
            return false;
        }
        String this$content = this.getContent();
        String other$content = other.getContent();
        if (this$content == null ? other$content != null : !this$content.equals(other$content)) {
            return false;
        }
        String this$rawType = this.getRawType();
        String other$rawType = other.getRawType();
        return !(this$rawType == null ? other$rawType != null : !this$rawType.equals(other$rawType));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ContentWrapper;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $snapshotName = this.getSnapshotName();
        result = result * 59 + ($snapshotName == null ? 43 : $snapshotName.hashCode());
        String $raw = this.getRaw();
        result = result * 59 + ($raw == null ? 43 : $raw.hashCode());
        String $content = this.getContent();
        result = result * 59 + ($content == null ? 43 : $content.hashCode());
        String $rawType = this.getRawType();
        result = result * 59 + ($rawType == null ? 43 : $rawType.hashCode());
        return result;
    }

    public String toString() {
        return "ContentWrapper(snapshotName=" + this.getSnapshotName() + ", raw=" + this.getRaw() + ", content=" + this.getContent() + ", rawType=" + this.getRawType() + ")";
    }

    public static class ContentWrapperBuilder {
        private String snapshotName;
        private String raw;
        private String content;
        private String rawType;

        ContentWrapperBuilder() {
        }

        public ContentWrapperBuilder snapshotName(String snapshotName) {
            this.snapshotName = snapshotName;
            return this;
        }

        public ContentWrapperBuilder raw(String raw) {
            this.raw = raw;
            return this;
        }

        public ContentWrapperBuilder content(String content) {
            this.content = content;
            return this;
        }

        public ContentWrapperBuilder rawType(String rawType) {
            this.rawType = rawType;
            return this;
        }

        public ContentWrapper build() {
            return new ContentWrapper(this.snapshotName, this.raw, this.content, this.rawType);
        }

        public String toString() {
            return "ContentWrapper.ContentWrapperBuilder(snapshotName=" + this.snapshotName + ", raw=" + this.raw + ", content=" + this.content + ", rawType=" + this.rawType + ")";
        }
    }
}

